/**

author: Aiven Wolf
date: 21. 2. 2025
email: technik@lcd-module.de

  Getting Started with Modbus RTU on Opta™
  Name: Opta_Client
  Purpose: Writes Coil and Holding Register values; Reads Coil, Discrete Input, Holding Registers, and Input Register values.

  @author Arduino
*/

#include <ArduinoModbus.h>
#include <ArduinoRS485.h> // ArduinoModbus depends on the ArduinoRS485 library

constexpr auto modbus_adress = 42;
constexpr auto baudrate { 115200 };

// Calculate preDelay and postDelay in microseconds as per Modbus RTU Specification
// MODBUS over serial line specification and implementation guide V1.02
// Paragraph 2.5.1.1 MODBUS Message RTU Framing
// https://modbus.org/docs/Modbus_over_serial_line_V1_02.pdf
constexpr auto bitduration { 1.f / baudrate };
constexpr auto preDelayBR { bitduration * 9.6f * 3.5f * 1e6 };
constexpr auto postDelayBR { bitduration * 9.6f * 3.5f * 1e6 };
// constexpr auto preDelayBR { bitduration * 10.0f * 3.5f * 1e6 };

bool in_switch = 0;  //holds the value for Input
bool out_light = 0;  //holds the value for output
bool modbus_on = 1;  //bool to interrupt modbus communication
bool last_user_state = 1;

int in_analog = 0;  //holds the value for analoginput

void setup() {
    Serial.begin(9600);
   // while (!Serial);    //debug interface

    Serial.println("Modbus RTU Master");
    RS485.setDelays(preDelayBR, postDelayBR);

    // Start the Modbus RTU Master
    if (!ModbusRTUClient.begin(baudrate, SERIAL_8N1)) {
        Serial.println("Failed to start Modbus RTU Master!");
        while (1);
    }
    pinMode(A0,  INPUT);
    pinMode(RELAY1, OUTPUT);
    pinMode (BTN_USER, INPUT);  //User button is used to interrupt modbus communication
    analogReadResolution(12);
}

void loop() {
  
  if (digitalRead(BTN_USER) == 0 && last_user_state){   //checks button and last user state
  digitalWrite(LED_USER, modbus_on);    //turns on user LED on or off  
  modbus_on = !modbus_on;         //set modbus = 1 to 0 and Modbus = 0 to 1
  last_user_state = 0;           //set last user to 0
  }
  if (digitalRead(BTN_USER) == 1 && last_user_state ==0){
  last_user_state = 1; 
  }
  if (modbus_on){
    in_switch = digitalRead(A0);   //reads Input pin A0
    writeCoilValues();           //send input state

    readDiscreteInputValues();          //read display, button state
    digitalWrite(RELAY1, out_light);   //output on pin RELAY1
    digitalWrite(LED_RELAY1, out_light);

    in_analog = analogRead(A1);        //reads analog value (12bit)
    writeHoldingRegisterValues();      //send analog value to display
    Serial.println();
   }
   
   delay(100);
} 

//Writes Coil values to the server under specified address.
void writeCoilValues() {

    Serial.print("Writing Coil values ... ");
    // Srite 10 Coil values to (server) id 42, address 0x00
    ModbusRTUClient.beginTransmission(modbus_adress, COILS, 0x1, 1); 
    ModbusRTUClient.write(in_switch);
    if (!ModbusRTUClient.endTransmission()) {
        Serial.print("failed! ");
        Serial.println(ModbusRTUClient.lastError());
    } else {
        Serial.println("success");
    }
}
  //Reads Coil values from the server under specified address.
void readCoilValues() {
    Serial.print("Reading Coil values ... ");

    // Read 10 Coil values from (server) id 42, address 0x00
    if (!ModbusRTUClient.requestFrom(modbus_adress, COILS, 0x00, 10)) {
        Serial.print("failed! ");
        Serial.println(ModbusRTUClient.lastError());
    } else {
        Serial.println("success");

        while (ModbusRTUClient.available()) {
            Serial.print(ModbusRTUClient.read());
            Serial.print(' ');
        }
        Serial.println();
    }
    // Alternatively, to read a single Coil value use:
    // ModbusRTUMaster.coilRead(...)
}
     //Reads Discrete Input values from the server under specified address.
void readDiscreteInputValues() {
    Serial.print("Reading Discrete Input values ... ");

    // Read 10 Discrete Input values from (server) id 42, address 0x00
    if (!ModbusRTUClient.requestFrom(modbus_adress, DISCRETE_INPUTS, 0x1, 1)) {
        Serial.print("failed! ");
        Serial.println(ModbusRTUClient.lastError());
    } else {
        Serial.println("success");

        while (ModbusRTUClient.available()) {
          out_light = ModbusRTUClient.read();
            Serial.print(out_light);
            Serial.print(' ');
        }
        Serial.println();
    }
     // Alternatively, to read a single Discrete Input value use:
     // ModbusRTUClient.discreteInputRead(...)
}
     // Writes Holding Register values to the server under specified address.
void writeHoldingRegisterValues() {
    //Set the Holding Register values to counter
    Serial.print("Writing Holding Registers values ... ");

    // Write 10 coil values to (server) id 42, address 0x00
    ModbusRTUClient.beginTransmission(modbus_adress, HOLDING_REGISTERS, 0x1, 2);
        ModbusRTUClient.write(in_analog);
        ModbusRTUClient.write(0);

    if (!ModbusRTUClient.endTransmission()) {
        Serial.print("failed! ");
        Serial.println(ModbusRTUClient.lastError());
    } else {
        Serial.println("success");
    }
    // Alternatively, to write a single Holding Register value use:
    // ModbusRTUClient.holdingRegisterWrite(...)
}

/**
  Reads Holding Register values from the server under specified address.
*/
void readHoldingRegisterValues() {
    Serial.print("Reading Holding Register values ... ");

    // Read 10 Input Register values from (server) id 42, address 0x00
    if (!ModbusRTUClient.requestFrom(42, HOLDING_REGISTERS, 0x00, 10)) {
        Serial.print("failed! ");
        Serial.println(ModbusRTUClient.lastError());
    } else {
        Serial.println("success");

        while (ModbusRTUClient.available()) {
            Serial.print(ModbusRTUClient.read());
            Serial.print(' ');
        }
        Serial.println();
    }

    // Alternatively, to read a single Holding Register value use:
    // ModbusRTUClient.holdingRegisterRead(...)
}